using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Threading;

using DShowNET;
using DShowNET.Device;
using CKFolderDialogH;


namespace GKSecureCam
{
    public partial class MainForm : Form, ISampleGrabberCB
    {

        private String SettingFileName = "setting.txt";
        private String OutPutFolder = "";
        private Int32 FileNum = 1;
        private Int32 SaveType = 0;
        private Double FreeSpaceRatio;
        private Int32 FileNum_Max = 10000;

        private bool activeFlag = false;	//捞݃[vLtO
        private bool capturedFlag = false;	//Lv`̏ItO
        private bool updatedFlag = false;   //rbg}bv̍XVtO

        private ArrayList captureDevices;        //JfoCẌꗗ

        private IBaseFilter captureFilter; //\[XtB^
        object captureObject = null;
        private IGraphBuilder graphBuilder; //{IȃtB^Ot}l[W
        private IVideoWindow videoWindow; //I[i[EBhËʒuTCYȂǂ̐ݒp̃C^tF[XD
        private IMediaControl mediaControl;//f[^̃Xg[~ÖړA|[YA~Ȃǂ̏p̃C^tF[XD
        private IMediaEventEx mediaEvent; //DirectShowCxgp̃C^tF[X

        private VideoInfoHeader videoInfoHeader; //rfIC[W̃tH[}bgLq\

        private ICaptureGraphBuilder2 captureGraphBuilder;  //rfILv`ҏWp̃\bhLv`Otr_
        private ISampleGrabber sampleGrabber;               //tB^OtʂX̃f[^擾p̃C^tF[X
        private IBaseFilter grabFilter; //Grabber Filter̃C^tF[XD
        int result; //G[ptO

        private const int WS_CHILD = 0x40000000;
        private const int WS_CLIPCHILDREN = 0x02000000;
        public const int WM_GRAPHNOTIFY = 0x00008001;//DirectShowCxg̔\Windows bZ[W.

        private byte[] frameArray;//Lv`t[f[^p̔z	
        private delegate void CaptureDone();//Î~Lv`ȈsfQ[h
        private Bitmap capturedBitmap = null;//Lv`t[f[^p̃rbg}bv

        private Thread timerThread;
        private Int32 threadWait = 1000;


        public MainForm()
        {
            InitializeComponent();
        }


        /// <summary>
        /// tH[̃[h̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void MainForm_Load(object sender, EventArgs e)
        {
            Load_Settings();
            Init_DirectShow();            //DirectShow̏
        }

        /// <summary>
        /// ݒ̃[h
        /// </summary>
        private void Load_Settings()
        {
            if (File.Exists(SettingFileName))
            {
                StreamReader sr = new StreamReader("setting.txt");

                TB_OUTPUT_FOLDER.Text = sr.ReadLine();
                CB_SAVE_INTERVAL.SelectedIndex = Int32.Parse(sr.ReadLine());
                if (sr.ReadLine() == "0")
                {
                    RB_FNLOOP_TYPE1.Checked = true;
                }
                else
                {
                    RB_FNLOOP_TYPE2.Checked = true;
                }
                TB_RESO_X.Text = sr.ReadLine();
                TB_RESO_Y.Text = sr.ReadLine();
                TB_LOOP_MAX.Text = sr.ReadLine();

                sr.Close();
            }
        }

        /// <summary>
        /// ݒ̃Z[u
        /// </summary>
        private void Save_Settings()
        {
            StreamWriter sw = new StreamWriter(SettingFileName);

            sw.WriteLine(TB_OUTPUT_FOLDER.Text);
            sw.WriteLine(CB_SAVE_INTERVAL.SelectedIndex.ToString());
            if (RB_FNLOOP_TYPE1.Checked == true)
            {
                sw.WriteLine("0");
            }
            else
            {
                sw.WriteLine("1");
            }
            sw.WriteLine(TB_RESO_X.Text);
            sw.WriteLine(TB_RESO_Y.Text);
            sw.WriteLine(TB_LOOP_MAX.Text);

            for (Int32 a = 0; a < 20; a++)
            {
                sw.WriteLine("---");
            }
            
            sw.Close();
        }


        /// <summary>
        /// DirectShow̏
        /// </summary>
        private void Init_DirectShow()
        {

            DsDevice device = null;
            Type comType = null;
			object comObject = null;


            //PCɐڑĂLv`foCXiUSBJȂ)̃Xg擾D
            if (!DsDev.GetDevicesOfCat(FilterCategory.VideoInputDevice, out captureDevices))
            {
                MessageBox.Show("rfILv`\ȃfoCX܂D");
                GB_IO_SETTING.Enabled = false;
                GB_MAIN_CONTROL.Enabled = false;
                GB_OPERATION_SETTING.Enabled = false;
                return;
            }

            //foCXR{{bNXɕ\
            CB_CAMERA_LIST.Items.Clear();
            for (Int32 a = 0; a < captureDevices.Count; a++)
            {
                device = captureDevices[a] as DsDevice;
                CB_CAMERA_LIST.Items.Add(device.Name);
            }

            CB_CAMERA_LIST.SelectedIndex = 0;


            //\\\\\\
            device = captureDevices[0] as DsDevice;

            //Lv`foCX(device)ƃ\[XtB^(captureFilter)ΉtD
            Guid guidBF = typeof(IBaseFilter).GUID;
            device.Mon.BindToObject(null, null, ref guidBF, out captureObject);
            captureFilter = (IBaseFilter)captureObject;

            //graphBuilder쐬
            comType = Type.GetTypeFromCLSID(Clsid.FilterGraph);
            comObject = Activator.CreateInstance(comType);
            graphBuilder = (IGraphBuilder)comObject;
            comObject = null;

            //eC^tF[X擾
            mediaControl = (IMediaControl)graphBuilder;
            videoWindow = (IVideoWindow)graphBuilder;
            mediaEvent = (IMediaEventEx)graphBuilder;

            //Lv`Otr_(captureGraphBuilder)쐬D
            comType = Type.GetTypeFromCLSID(Clsid.CaptureGraphBuilder2);
            comObject = Activator.CreateInstance(comType);
            captureGraphBuilder = (ICaptureGraphBuilder2)comObject;
            comObject = null;


            //\\\\\𑜓xݒ
            Guid pCategory = PinCategory.Capture ;
            Guid pType = MediaType.Video;
            Guid riid = typeof(IAMStreamConfig).GUID;
            object iam;
            captureGraphBuilder.FindInterface(ref pCategory, ref pType, captureFilter, ref riid, out iam);
            IAMStreamConfig config = iam as IAMStreamConfig;

            AMMediaType curMedType;
            int piCount, piSize;
            config.GetNumberOfCapabilities(out piCount, out piSize);

            IntPtr pSCC = Marshal.AllocCoTaskMem(piSize);

            Int32 reso_X = Int32.Parse(TB_RESO_X.Text);
            Int32 reso_Y = Int32.Parse(TB_RESO_Y.Text);

            for (Int32 a = 0; a < piCount; a++)
            {
                config.GetStreamCaps(a, out curMedType, pSCC);

                if (curMedType.majorType == MediaType.Video &&
                    curMedType.subType == MediaSubType.RGB24)
                {
                    VideoInfoHeader Vih_tmp = (VideoInfoHeader)Marshal.PtrToStructure(curMedType.formatPtr, typeof(VideoInfoHeader));

                    if (Vih_tmp.BmiHeader.Width == reso_X && Vih_tmp.BmiHeader.Height == reso_Y)
                    {
                        config.SetFormat(curMedType);
                    }
                }
            }


            //TvOo(sampleGrabber)쐬
            comType = Type.GetTypeFromCLSID(Clsid.SampleGrabber);
            comObject = Activator.CreateInstance(comType);
            sampleGrabber = (ISampleGrabber)comObject;
            comObject = null;

            //tB^Ɗ֘At
            grabFilter = (IBaseFilter)sampleGrabber;

            //Lv`rfIf[^̃tH[}bgݒD
            AMMediaType amMediaType = new AMMediaType();
            amMediaType.majorType = MediaType.Video;
            amMediaType.subType = MediaSubType.RGB24;
            amMediaType.formatType = FormatType.VideoInfo;

            result = sampleGrabber.SetMediaType(amMediaType);
                if (result < 0) Marshal.ThrowExceptionForHR(result);

            //captureGraphBuilderiLv`Otr_jgraphBuilderitB^Ot}l[WjɒǉD
            result = captureGraphBuilder.SetFiltergraph(graphBuilder);
                if (result < 0) Marshal.ThrowExceptionForHR(result);

            //captureFilter(\[XtB^)graphBuilderitB^Ot}l[WjɒǉD
            result = graphBuilder.AddFilter(captureFilter, "Video Capture Device");
                if (result < 0) Marshal.ThrowExceptionForHR(result);

            //grabFilter(ϊtB^)graphBuilderitB^Ot}l[WjɒǉD
            result = graphBuilder.AddFilter(grabFilter, "Frame Grab Filter");
                if (result < 0) Marshal.ThrowExceptionForHR(result);

            Guid pinCategory;
            Guid mediaType;

            //Lv`tB^TvOo[tB^ɐڑD
            pinCategory = PinCategory.Capture;
            mediaType = MediaType.Video;
            result = captureGraphBuilder.RenderStream(ref pinCategory, ref mediaType, captureFilter, null, grabFilter);
            if (result < 0) Marshal.ThrowExceptionForHR(result);
            //Lv`tB^ftHg̃_tB^ifBXvCɏójɐڑDivr[j
            pinCategory = PinCategory.Preview;
            mediaType = MediaType.Video;
            result = captureGraphBuilder.RenderStream(ref pinCategory, ref mediaType, captureFilter, null, null);
            if (result < 0) Marshal.ThrowExceptionForHR(result);

            //t[Lv`̐ݒ肪mFD
            amMediaType = new AMMediaType();

            result = sampleGrabber.GetConnectedMediaType(amMediaType);
            if (result < 0) Marshal.ThrowExceptionForHR(result);
            if ((amMediaType.formatType != FormatType.VideoInfo) || (amMediaType.formatPtr == IntPtr.Zero))
                throw new NotSupportedException("Lv`łȂfBAtH[}bgłD");

            //Lv`rfIf[^̃tH[}bgCvideoInfoHeader쐬D
            videoInfoHeader = (VideoInfoHeader)Marshal.PtrToStructure(amMediaType.formatPtr, typeof(VideoInfoHeader));
            Marshal.FreeCoTaskMem(amMediaType.formatPtr);
            amMediaType.formatPtr = IntPtr.Zero;

            //tB^ʂTvobt@ɃRs[Ȃ悤Ɏw肷D
            result = sampleGrabber.SetBufferSamples(false);
            //Tvi1t[j󂯎tB^~悤Ɏw肷D
            if (result == 0) result = sampleGrabber.SetOneShot(false);
            //R[obN֐̗p~D
            if (result == 0) result = sampleGrabber.SetCallback(null, 0);
            if (result < 0) Marshal.ThrowExceptionForHR(result);

            //vr[f\plwD
            result = videoWindow.put_Owner(PB_IMAGE.Handle);
            if (result < 0) Marshal.ThrowExceptionForHR(result);
            //rfI\̈̃X^CwD
            result = videoWindow.put_WindowStyle(WS_CHILD | WS_CLIPCHILDREN);
            if (result < 0) Marshal.ThrowExceptionForHR(result);
            //rfIpl̃TCYύXD
            Rectangle rect = PB_IMAGE.ClientRectangle;
            videoWindow.SetWindowPosition(0, 0, rect.Right, rect.Bottom);

            //_tB^̏o͂D
            result = videoWindow.put_Visible(DsHlp.OATRUE);
            if (result < 0) Marshal.ThrowExceptionForHR(result);

            //mediaEvent(DirectShowCxg)WM_GRAPHNOTIFY(WindowsbZ[W)ɑΉtD 
            result = mediaEvent.SetNotifyWindow(this.Handle, WM_GRAPHNOTIFY, IntPtr.Zero);
            if (result < 0) Marshal.ThrowExceptionForHR(result);
        }



        /// <summary>
        /// {^F
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void B_END_Click(object sender, EventArgs e)
        {
            activeFlag = false;
            if (timerThread != null)
            {
                timerThread.Join();
                timerThread = null;
            }

            Save_Settings();
            this.Close();
        }


        /// <summary>
        /// {^Fo͐w
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void B_OUTPUT_FOLDER_Click(object sender, EventArgs e)
        {
            FolderDialogH fsd = new FolderDialogH();

            fsd.SelectedPath = @"C:\Windows";
            if (TB_OUTPUT_FOLDER.Text != "")
            {
                fsd.SelectedPath = TB_OUTPUT_FOLDER.Text;
            }

            //_CAO\
            if (fsd.ShowDialog(this) == DialogResult.OK)
            {
                TB_OUTPUT_FOLDER.Text = fsd.SelectedPath;
            }

            fsd.Dispose();
        }


        /// <summary>
        /// {^Fo͐tH_GNXv[ŊJ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void B_OPEN_FOLDER_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("EXPLORER.EXE", TB_OUTPUT_FOLDER.Text);
        }


        /// <summary>
        /// {^FeXg捞݃X^[g
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void B_TEST_GRABBING_START_Click(object sender, EventArgs e)
        {
            B_TEST_GRABBING_START.Enabled = false;
            B_TEST_GRABBING_STOP.Enabled = true;
            GB_MAIN_CONTROL.Enabled = false;

            result = mediaControl.Run();
            if (result < 0) Marshal.ThrowExceptionForHR(result); 
        }


        /// <summary>
        /// {^FeXg捞݃Xgbv
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void B_TEST_GRABBING_STOP_Click(object sender, EventArgs e)
        {
            result = mediaControl.Stop();
            if (result < 0) Marshal.ThrowExceptionForHR(result);

            B_TEST_GRABBING_START.Enabled = true;
            B_TEST_GRABBING_STOP.Enabled = false;
            GB_MAIN_CONTROL.Enabled = true;
        }


        /// <summary>
        /// {^FJn
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void B_EXEC_START_Click(object sender, EventArgs e)
        {
            B_EXEC_START.Enabled = false;
            B_EXEC_STOP.Enabled = true;
            GB_OPERATION_SETTING.Enabled = false;
            GB_IO_SETTING.Enabled = false;
            GB_STATUS.Enabled = true;

            activeFlag = true;
            CaptureStillImage();
        }


        /// <summary>
        /// {^F~
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void B_EXEC_STOP_Click(object sender, EventArgs e)
        {
            activeFlag = false;

            B_EXEC_START.Enabled = true;
            B_EXEC_STOP.Enabled = false;
            GB_OPERATION_SETTING.Enabled = true;
            GB_IO_SETTING.Enabled = true;
            GB_STATUS.Enabled = false;

            if (timerThread != null)
            {
                timerThread.Join();
                timerThread = null;
            }
        }


        private void CaptureStillImage()
        {
            if (timerThread != null)
            {
                timerThread.Abort();
                timerThread = null;
            }

            threadWait = Int32.Parse(CB_SAVE_INTERVAL.Text) * 1000;
            OutPutFolder = TB_OUTPUT_FOLDER.Text;
            FileNum = 1;
            FileNum_Max = Int32.Parse(TB_LOOP_MAX.Text);

            if (RB_FNLOOP_TYPE1.Checked == true)
            {
                SaveType = 0;
            }
            else
            {
                SaveType = 1;
            }

            timerThread = new Thread(new ThreadStart(this.CaptureStillWorker));
            timerThread.Start();
        }


        private void CaptureStillWorker()
        {
            try
            {
                while (activeFlag == true)
                {
                    StartGrabber();
                    Thread.Sleep(threadWait);
                    GC.Collect();
                    GC.WaitForPendingFinalizers();
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }	
        }

        //Î~̃Lv`JnD
        public bool StartGrabber()
        {
            int result;

            if (sampleGrabber == null) return false;

            if (frameArray == null)
            {
                //Lv`t[f[^̃TCYݒ肷D
                int size = videoInfoHeader.BmiHeader.ImageSize;
                if ((size < 1000) || (size > 16000000)) return false; //TCYKH	
                frameArray = new byte[size + 64000];
            }

            Image pre = null;

            pre = this.PictureBoxImage;
            this.PictureBoxImage = null;

            if (pre != null)
                pre.Dispose();

            capturedFlag = false;

            try
            {

                //rfIf[^̃TvOɗpR[obN \bhw肷D
                //	 ISampleGrabberCB C^[tFCXւ̃|C^
                //			 nullw肷ƃR[obN
                //	0->ISampleGrabberCB.SampleCB \bh𗘗p 	
                //			1->ISampleGrabberCB.BufferCB \bh𗘗p
                result = sampleGrabber.SetCallback(this, 1);
                mediaControl.Run();
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
                activeFlag = false;
            }
            return true;
        }

        public Image PictureBoxImage
        {
            set { PB_IMAGE.Image = value; }
            get { return PB_IMAGE.Image; }
        }

        //t[Lv`ɌĂяoR[obN֐
        int ISampleGrabberCB.SampleCB(double SampleTime, IMediaSample pSample)
        {
            return 0;
        }

        //t[Lv`ɌĂяoR[obN֐
        int ISampleGrabberCB.BufferCB(double SampleTime, IntPtr pBuffer, int BufferLength)
        {
            //ɃR[obNĂяoĂ邩CframeArrayĂȂΏID
            if (capturedFlag || (frameArray == null))
            {
                return 0;
            }

            capturedFlag = true;
            //̃TvOꂽf[^(pBuffer)z(frameArray)ɃRs[D
            if ((pBuffer != IntPtr.Zero) && (BufferLength > 1000) && (BufferLength <= frameArray.Length))
                Marshal.Copy(pBuffer, frameArray, 0, BufferLength);

            try
            {
                //CaptureDonefQ[hĂяoD
                this.BeginInvoke(new CaptureDone(this.OnCaptureDone));
            }
            catch (Exception e)
            {
                MessageBox.Show(e.ToString());
            }
            return 0;
        }


        //Lv`f[^̔zԓɌŒ肵Crbg}bvɕϊD 
        void OnCaptureDone()
        {
            try
            {
                int result;
                if (sampleGrabber == null) return;

                //R[obN֐̗p~
                result = sampleGrabber.SetCallback(null, 0);

                //t[f[^̃TCY擾
                int width = videoInfoHeader.BmiHeader.Width;
                int height = videoInfoHeader.BmiHeader.Height;

                //width4̔{łȂꍇwidthheight̒lKłȂꍇ͏ID
                if (((width & 0x03) != 0) || (width < 32) || (width > 4096) || (height < 32) || (height > 4096))
                    return;

                //stride(1C̃f[^TCY(byte)=width* 3(RGB))ݒD
                int stride = width * 3;

                //zframeArraỹAhXCԓŌŒ肷D
                GCHandle gcHandle = GCHandle.Alloc(frameArray, GCHandleType.Pinned);

                int addr = (int)gcHandle.AddrOfPinnedObject();
                addr += (height - 1) * stride;

                //frameArrayi[AhXCrbg}bvf[^쐬D
                Bitmap bitmap = new Bitmap(width, height, -stride, PixelFormat.Format24bppRgb, (IntPtr)addr);
                capturedBitmap = new Bitmap(width, height, -stride, PixelFormat.Format24bppRgb, (IntPtr)addr);
                gcHandle.Free();
                frameArray = null;

                Image pre = null;

                //ʏɃLv`摜\D
                pre = this.PictureBoxImage;
                this.PictureBoxImage = bitmap;

                //hCu󂫗eʂ̊mF
                FreeSpaceRatio = GetDriveCapacityRatio(OutPutFolder);

                //t@Cɕۑ
                String OutPutSubFolder = Get_SubOutputFolder(FileNum);

                String[] fileList = Directory.GetFileSystemEntries(OutPutFolder + "\\" + OutPutSubFolder, "*" + FileNum.ToString("0000") + "*");
                if(fileList.Length > 0)
                {
                    File.Delete(fileList[0]);
                }


                DateTime dt = DateTime.Now;
                String FileNameBody = "Image_" + FileNum.ToString("0000") + "_" + dt.ToString("HHmmss");

                //iw
                Int64 q = 85;
                EncoderParameters eps = new System.Drawing.Imaging.EncoderParameters(1);
                EncoderParameter ep = new System.Drawing.Imaging.EncoderParameter(System.Drawing.Imaging.Encoder.Quality, q);
                eps.Param[0] = ep;

                ImageCodecInfo jpgEncoder = null;
                // JPEGp̃GR[_̎擾
                foreach (ImageCodecInfo ici in ImageCodecInfo.GetImageEncoders())
                {
                    if (ici.FormatID == ImageFormat.Jpeg.Guid)
                    {
                        jpgEncoder = ici;
                        break;
                    }
                }

                this.PictureBoxImage.Save(OutPutFolder + "\\" + OutPutSubFolder + "\\" + FileNameBody + ".jpg", jpgEncoder, eps);


                //Xe[^XXV
                this.Invoke(new DelegateUpdateStatus(this.OnUpdateStatus));


                FileNum++;
                if (SaveType == 1)
                {
                    if (FileNum > FileNum_Max)
                    {
                        FileNum = 1;
                    }
                }

                if (pre != null) pre.Dispose();

                //XVD
                updatedFlag = true;

                mediaControl.Stop();

                return;
            }
            catch (Exception e)
            {
                MessageBox.Show("t[̃Lv`iGrabjɎs܂D" + e.ToString());
            }
        }


        /// <summary>
        /// o͗p̃TutH_擾
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        public String Get_SubOutputFolder(Int32 index)
        {
            Double m_tmp = (Double)(index) / 1000;

            Int32 m_floor = (Int32)(Math.Floor(m_tmp) * 1000);
            Int32 m_Ceiling = (Int32)(Math.Ceiling(m_tmp) * 1000);

            if (m_floor == m_Ceiling)
            {
                m_floor -= 1000;
            }

            String ret = m_floor.ToString("00000") + "-" + m_Ceiling.ToString("00000");

            String foldertmp = OutPutFolder + "\\" + ret;

            if(!Directory.Exists(foldertmp))
            {
                Directory.CreateDirectory(foldertmp);
            }

            return ret;
        }


        /// <summary>
        /// hCu̎ceʂ̊擾܂B
        /// </summary>
        /// <param name="folderPath">擾hCuwtH_̃pX</param>
        /// <returns>hCu̎ceʂ̊</returns>
        public static Double GetDriveCapacityRatio(String folderPath)
        {
            DriveInfo info = new DriveInfo(Path.GetPathRoot(folderPath));

            // hCȗS̗e
            Int64 totalCapacity = info.TotalSize;
            // ݂̋󂫗e
            Int64 freeCapacity = info.AvailableFreeSpace;

            // ݂̋󂫊
            Double freeRatio = (Double)freeCapacity / totalCapacity * 100;

            return freeRatio;
        }


        /// <summary>
        /// Xe[^X̍XV@fQ[g
        /// </summary>
        public delegate void DelegateUpdateStatus();

        /// <summary>
        /// Xe[^X̍XV
        /// </summary>
        private void OnUpdateStatus()
        {
            L_FILEINDEX.Text = FileNum.ToString("00000");
            L_FREESPACE.Text = FreeSpaceRatio.ToString("0.0") + " %";
        }


    }


}