using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

namespace WindowsApplication1
{
    public partial class MainForm : Form
    {
        private const int MOUSEEVENTF_LEFTDOWN = 0x2;
        private const int MOUSEEVENTF_LEFTUP = 0x4;

        private Boolean ModeFlag;


        [DllImport("USER32.dll", CallingConvention = CallingConvention.StdCall)]
        static extern void SetCursorPos(int X, int Y);

        [DllImport("USER32.dll", CallingConvention = CallingConvention.StdCall)]
        static extern void mouse_event(int dwFlags, int dx, int dy, int cButtons, int dwExtraInfo);


        public MainForm()
        {
            InitializeComponent();
        }


        //tH[[h̏
        private void MainForm_Load(object sender, EventArgs e)
        {
            Load_Settings();

            ModeFlag = false;
            timer1.Stop();
        }


        //ݒۑ
        private void Save_Settings()
        {
            StreamWriter sw = new StreamWriter("setting.ini");

            sw.WriteLine(Int32.Parse(TB_POS_X.Text));
            sw.WriteLine(Int32.Parse(TB_POS_Y.Text));
            sw.WriteLine(Int32.Parse(TB_INTERVAL.Text));

            sw.Close();
        }

        //ݒǂݏo
        private void Load_Settings()
        {
            if (File.Exists("setting.ini") == true)
            {
                StreamReader sr = new StreamReader("setting.ini");

                TB_POS_X.Text = sr.ReadLine();
                TB_POS_Y.Text = sr.ReadLine();
                TB_INTERVAL.Text = sr.ReadLine();

                sr.Close();
            }
            else
            {
                TB_POS_X.Text = "100";
                TB_POS_Y.Text = "100";
                TB_INTERVAL.Text = "1000";
            }
        }


        //I{^
        private void B_END_Click(object sender, EventArgs e)
        {
            Save_Settings();
            this.Close();
        }


        //}EXJ[\ړmF
        private void B_MOVECOURSOR_Click(object sender, EventArgs e)
        {
            Move_Corsor();
        }


        //͒l̐
        private void TB_INTERVAL_TextChanged(object sender, EventArgs e)
        {
            try
            {
                Int32 tmp = Int32.Parse(TB_INTERVAL.Text);

                if (tmp < 1000)
                {
                    tmp = 1000;
                    TB_INTERVAL.Text = tmp.ToString();
                }
            }
            catch
            {
                TB_INTERVAL.Text = "1000";
            }

        }


        //Jn~{^
        private void B_STARTSTOP_Click(object sender, EventArgs e)
        {
            if (ModeFlag == true)
            {
                //~
                ModeFlag = false;
                timer1.Stop();
                B_STARTSTOP.Text = "Jn";
            }
            else
            {
                //Jn
                ModeFlag = true;
                B_STARTSTOP.Text = "~";

                Int32 interval = Int32.Parse(TB_INTERVAL.Text);
                timer1.Interval = interval;

                timer1.Start();
            }


        }


        //^C}[
        private void timer1_Tick(object sender, EventArgs e)
        {
            //J[\ʒuړ
            Move_Corsor();

            //NbN
            mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0);
            mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);
        }



        //}EXJ[\ړ
        private void Move_Corsor()
        {
            try
            {
                //Int32 posx = Int32.Parse(TB_POS_X.Text) - this.Bounds.Location.X;
                //Int32 posy = Int32.Parse(TB_POS_Y.Text) - this.Bounds.Location.Y;

                //System.Drawing.Point mp = this.PointToScreen(new System.Drawing.Point(posx, posy));
                //System.Windows.Forms.Cursor.Position = mp;

                Int32 posx = Int32.Parse(TB_POS_X.Text);
                Int32 posy = Int32.Parse(TB_POS_Y.Text);
                SetCursorPos(posx, posy);
            }
            catch
            {
                if (ModeFlag == true)
                {
                    ModeFlag = false;
                    timer1.Stop();
                    B_STARTSTOP.Text = "Jn";
                }
                MessageBox.Show("}EXJ[\̈ړɎs܂B");
            }
        }

    }
}