using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;

namespace AutoKeyput
{
    public partial class MainForm : Form
    {
        private Int32 procStep;
        private ComboBox[] CBS = new ComboBox[4];


        public MainForm()
        {
            InitializeComponent();
        }


        //[h̏
        private void Form1_Load(object sender, EventArgs e)
        {
            CBS[0] = CB_KEY1;
            CBS[1] = CB_KEY2;
            CBS[2] = CB_KEY3;
            CBS[3] = CB_KEY4;

            RB_REPEAT1.Checked = true;

            Load_Settings();

            if (File.Exists("autostart.ini") == true)
            {
                Start_Process();
            }
        }


        //s{^
        private void B_EXEC_Click(object sender, EventArgs e)
        {
            Start_Process();
        }


        //I{^
        private void B_END_Click(object sender, EventArgs e)
        {
            Save_Settings();
            this.Close();
        }


        //ݒۑ
        private void Save_Settings()
        {
            StreamWriter sw = new StreamWriter("setting.ini");

            sw.WriteLine(TB_WAITTIME.Text);
            sw.WriteLine(TB_INTERVALTIME.Text);
            sw.WriteLine(CB_KEY1.SelectedIndex.ToString());
            sw.WriteLine(CB_KEY2.SelectedIndex.ToString());
            sw.WriteLine(CB_KEY3.SelectedIndex.ToString());
            sw.WriteLine(CB_KEY4.SelectedIndex.ToString());

            sw.Close();
        }

        //ݒǂݏo
        private void Load_Settings()
        {
            if (File.Exists("setting.ini") == true)
            {
                StreamReader sr = new StreamReader("setting.ini");

                TB_WAITTIME.Text = sr.ReadLine();
                TB_INTERVALTIME.Text = sr.ReadLine();
                CB_KEY1.SelectedIndex = Int32.Parse(sr.ReadLine());
                CB_KEY2.SelectedIndex = Int32.Parse(sr.ReadLine());
                CB_KEY3.SelectedIndex = Int32.Parse(sr.ReadLine());
                CB_KEY4.SelectedIndex = Int32.Parse(sr.ReadLine());

                sr.Close();
            }
            else
            {
                TB_WAITTIME.Text = "3000";
                TB_INTERVALTIME.Text = "300";
                CB_KEY1.SelectedIndex = 0;
                CB_KEY2.SelectedIndex = 0;
                CB_KEY3.SelectedIndex = 0;
                CB_KEY4.SelectedIndex = 0;
            }
        }


        //X^[g
        private void Start_Process()
        {
            Thread.Sleep(Int32.Parse(TB_WAITTIME.Text));
            procStep = 0;
            L_STEP.Text = procStep.ToString();

            timer1.Interval = Int32.Parse(TB_INTERVALTIME.Text);
            timer1.Start();
        }


        //^C}[
        private void timer1_Tick(object sender, EventArgs e)
        {

            if (procStep == -1)
            {
                //[vĖ߂ĂƂ
                procStep = 0;
                timer1.Interval = Int32.Parse(TB_INTERVALTIME.Text);
                return;
            }

            if (procStep < -999)
            {
                //STOP{^ꂽƂ
                timer1.Stop();
                return;
            }


            String keyStr = CBS[procStep].Text;

            if (keyStr != "none")
            {
                SendKeys.Send(keyStr);
            }

            procStep++;
            if (procStep > 3)
            {
                timer1.Stop();
                if (RB_REPEAT2.Checked == true)
                {
                    Save_Settings();
                    this.Close();
                }

                if (RB_REPEAT3.Checked == true)
                {
                    timer1.Interval = 5000;
                    timer1.Start();
                    procStep = -1;
                }
            }
            L_STEP.Text = procStep.ToString();
        }

        //STOP{^Ƃ
        private void B_STOP_Click(object sender, EventArgs e)
        {
            procStep = -1000;
        }




    }
}