﻿
//=============================================================================
//
//  ps_amime.js チャンネル登録バナーアニメ
//　　　　　　　　　　　　                              Programmed by G.K.2021.3.31
//
//=============================================================================

//***************************************************************************** */
// 変数の宣言
//***************************************************************************** */
var canvas;				        //メインのキャンバスオブジェクト
var ctx;				        //２Ｄ描画コンテキスト

// 画像オブジェクト------------------------------
var img_youtubeicon = new Image();     //画像（YouTubeアイコン）
var img_stringmain = new Image();      //画像（文字メイン）
var img_stringsub = new Image();       //画像（文字サブ）

//フラグ--------------------------------------------
var FLG_Running;                //アニメーション動作中フラグ
var FLG_AnimeStep;              //アニメーションステップ

var FolderString;               //フォルダ別指定の場合


//***************************************************************************** */
// 関数の宣言
//***************************************************************************** */
//::::::::::::::::::::::::::::::::::::::::::::::::::::
// 初期化処理（一番最初）
function init(str) {
    //描画コンテキストの取得------------------------------------------------
    //メインキャンバス
    canvas = document.getElementById("mainCanvas");
    if ( ! canvas || ! canvas.getContext ) { return false; }
    ctx = canvas.getContext('2d');

    //画像の読み込み
    img_stringmain.src = str + "parts/stringmain.png";
    img_stringsub.src = str + "parts/stringsub.png";
    img_youtubeicon.src = str + "parts/youtubeicon.png";

    FLG_Running = 1;
    FLG_AnimeStep = 0;

    draw();
}



//***************************************************************************** */
// 描画系
//***************************************************************************** */
//::::::::::::::::::::::::::::::::::::::::::::::::::::
//背景を描画
function draw() {

    ctx.globalAlpha = 1.0;
    ctx.fillStyle = "rgb(255, 0, 0)";
    ctx.font = "12px 'ＭＳ Ｐゴシック'";

    //画像ロードされていない場合の処理
    if(img_youtubeicon.complete == false) {
        ctx.fillText("Now Loading...", 0, 15);
        Loop_FuncID = setTimeout(draw, 100);
        return;
    }

    //キャンバスのクリア
    ctx.fillRect(0, 0, 260, 46);

    //アイコンの表示
    var px1;
    if(FLG_AnimeStep < 10)
    {
        ctx.globalAlpha = 0.1 * FLG_AnimeStep;
        px1 = -5 + FLG_AnimeStep;
    }
    else
    {
        ctx.globalAlpha = 1.0;
        px1 = 5;
    }

    ctx.drawImage(img_youtubeicon, px1, 5);

    //文字（メイン）の表示
    var px2;
    if(FLG_AnimeStep < 5)
    {
        ctx.globalAlpha = 0;
        px2 = 0;
    }
    else if (FLG_AnimeStep >= 5 && FLG_AnimeStep < 15)
    {
        ctx.globalAlpha = 0.1 * (FLG_AnimeStep - 5);
        px2 = 55 + (FLG_AnimeStep - 5);
    } else {
        ctx.globalAlpha = 1.0;
        px2 = 65;
    }

    ctx.drawImage(img_stringmain, px2, 0);

    //文字（サブ）の表示
    var px3;
    if(FLG_AnimeStep < 10)
    {
        ctx.globalAlpha = 0;
        px3 = 0;
    }
    else if (FLG_AnimeStep >= 10 && FLG_AnimeStep < 20)
    {
        ctx.globalAlpha = 0.1 * (FLG_AnimeStep - 10);
        px3 = 55 + (FLG_AnimeStep - 10);
    } else {
        ctx.globalAlpha = 1.0;
        px3 = 65;
    }

    ctx.drawImage(img_stringsub, px3, 26);


    //アニメーションON
    if(FLG_Running == 1) {
        FLG_AnimeStep ++;

        if(FLG_AnimeStep < 20) {
            Loop_FuncID = setTimeout(draw, 30);
        }
        else 
        {
            FLG_AnimeStep = 20;
            FLG_Running = 0;
            Loop_FuncID = setTimeout(draw, 30);
        }
    }
}


//**************************************************************************** */
// その他の関数
//***************************************************************************** */
//::::::::::::::::::::::::::::::::::::::::::::::::::::
// フォームロード時に最初に実行
function main(str) {
    init(str);
}

//::::::::::::::::::::::::::::::::::::::::::::::::::::
// ウィンドウを閉じる
function MM_closeFloatWindow(theURL) {
    window.close(this);
}

